<?php

namespace App\Controllers;

use CodeIgniter\RESTful\ResourceController;
use CodeIgniter\HTTP\ResponseInterface;

class UtilitiesController extends ResourceController
{
    protected $modelName = 'App\Models\UtilityModel';

    /**
     * Return an array of resource objects, themselves in array format.
     *
     * @return ResponseInterface
     */
    public function index()
    {
        return $this->model->findAll();
    }

    /**
     * Return the properties of a resource object.
     *
     * @param int|string|null $id
     *
     * @return ResponseInterface
     */
    public function show($id = null)
    {
        if(!$id) {
            $this->failNotFound('No Name provided.');
        }

        $utility = $this->model->find($id);
        if(!$utility) {
            $this->failServerError('Failed to find utility.');
        }

        return $this->respond($utility);
    }

    /**
     * Return a new resource object, with default properties.
     *
     * @return ResponseInterface
     */
    public function new()
    {
        return $this->model->getDefaultValues();
    }

    /**
     * Create a new resource object, from "posted" parameters.
     *
     * @return ResponseInterface
     */
    public function create()
    {
        $data = $this->request->getVar();
        if (!$this->model->insert($data)) {
            return $this->failValidationErrors($this->model->errors());
        }

        $name = $this->model->insertID();
        return $this->respondCreated(['name' => $name], 'Utility created successfully.');
    }

    /**
     * Return the editable properties of a resource object.
     *
     * @param int|string|null $id
     *
     * @return ResponseInterface
     */
    public function edit($id = null)
    {
        if (!$id) {
            $this->failNotFound('Utility Name is required');
        }

        $utility = $this->model->find($id);
        if (!$utility) {
            $this->failServerError('Failed to find utility.');
        }

        return $this->respond($utility);
    }

    /**
     * Add or update a model resource, from "posted" properties.
     *
     * @param int|string|null $id
     *
     * @return ResponseInterface
     */
    public function update($id = null)
    {
        if ($id === null) {
            return $this->failNotFound('No Name provided.');
        }

        $data = $this->model->find($id);
        if ($data === null) {
            return $this->failNotFound("Utility not found.");
        }

        $data = $this->request->getVar();
        if (!$this->model->update($id, $data)) {
            return $this->failValidationErrors($this->model->errors());
        }

        return $this->respondUpdated(['name' => $id], 'Utility updated successfully.');
    }

    /**
     * Delete the designated resource object from the model.
     *
     * @param int|string|null $id
     *
     * @return ResponseInterface
     */
    public function delete($id = null)
    {
        if ($id === null) {
            return $this->failNotFound('No Name provided.');
        }

        if (!$this->model->find($id)) {
            return $this->failNotFound("Utility not found.");
        }

        if (!$this->model->delete($id)) {
            return $this->failServerError('Failed to delete utility.');
        }

        return $this->respondDeleted(['id' => $id], 'Utility deleted successfully.');
    }
}
