<?php

namespace App\Models;

use CodeIgniter\Model;

class ReportDetailModel extends Model
{
    protected $table            = 'report_details';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['report_id', 'test_item_id', 'result', 'remarks'];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    protected array $casts = [];
    protected array $castHandlers = [];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    // protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [
        'report_id'    => 'required|integer|checkReportExists',
        'test_item_id' => 'required|integer|checkTestItemExists',
        'result'       => 'permit_empty|string|max_length[10]',
        'remarks'      => 'permit_empty|string|max_length[64]',
    ];
    protected $validationMessages   = [
        'report_id' => [
            'required' => 'Report ID is required.',
            'integer'  => 'Report ID must be an integer.',
            'checkReportExists' => 'The specified report does not exist.',
        ],
        'test_item_id' => [
            'required' => 'Test item ID is required.',
            'integer'  => 'Test item ID must be an integer.',
            'checkTestItemExists' => 'The specified test item does not exist.',
        ],
        'result' => [
            'required' => 'Result is required.',
            'string'   => 'Result must be a string.',
            'max_length' => 'Result cannot exceed 10 characters.',
        ],
        'remarks' => [
            'string'       => 'Remarks must be a string.',
            'max_length'   => 'Remarks cannot exceed 64 characters.',
        ],
    ];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
}
