<?php

namespace App\Models;

use CodeIgniter\Model;

class ReportModel extends Model
{
    protected $table            = 'reports';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['invoice_id', 'invoice_test_id'];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    protected array $casts = [];
    protected array $castHandlers = [];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    // protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [
        'invoice_id'       => 'required|integer|checkInvoiceExists',
        'invoice_test_id'  => 'required|integer|checkInvoiceTestExists'
    ];
    protected $validationMessages   = [
        'invoice_id'       => [
            'required'            => 'Invoice ID is required.',
            'integer'             => 'Invoice ID must be an integer.',
            'checkInvoiceExists'  => 'The specified invoice does not exist.'
        ],
        'invoice_test_id'  => [
            'required'                => 'Invoice Test ID is required.',
            'integer'                 => 'Invoice Test ID must be an integer.',
            'checkInvoiceTestExists'  => 'The specified invoice test does not exist.'
        ]
    ];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
}
